/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packloading;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.instances.ItemBlock;
import minecrafttransportsimulator.items.instances.ItemBullet;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.items.instances.ItemItem;
import minecrafttransportsimulator.items.instances.ItemPoleComponent;
import minecrafttransportsimulator.items.instances.ItemRoadComponent;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.AJSONBase;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.JSONBlock;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.jsondefs.JSONConfigSettings;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPack;
import minecrafttransportsimulator.jsondefs.JSONPanel;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;
import minecrafttransportsimulator.jsondefs.JSONSkin;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.JSONParser;
import minecrafttransportsimulator.packloading.LegacyCompatSystem;
import minecrafttransportsimulator.packloading.PackResourceLoader;
import minecrafttransportsimulator.systems.ConfigSystem;

public final class PackParser {
    private static final Map<String, File> packJarMap = new HashMap<String, File>();
    private static final Map<String, JSONPack> packMap = new HashMap<String, JSONPack>();
    private static final List<AItemPart.AItemPartCreator> partCreators = new ArrayList<AItemPart.AItemPartCreator>();
    private static final Map<String, Map<String, List<JSONSkin>>> skinMap = new HashMap<String, Map<String, List<JSONSkin>>>();
    public static final Map<String, List<String>> faultMap = new HashMap<String, List<String>>();
    private static final TreeMap<String, HashMap<String, AItemPack<?>>> packItemMap = new TreeMap();
    private static final Map<String, Map<String, JSONPanel>> panelMap = new HashMap<String, Map<String, JSONPanel>>();
    private static final Comparator<AItemPack<?>> packComparator = new Comparator<AItemPack<?>>(){

        @Override
        public int compare(AItemPack<?> itemA, AItemPack<?> itemB) {
            String totalAName = ((AJSONItem)itemA.definition).classification.toDirectory() + ((AJSONItem)itemA.definition).prefixFolders + ((AJSONItem)itemA.definition).systemName;
            if (itemA instanceof AItemSubTyped) {
                totalAName = totalAName + ((AItemSubTyped)itemA).subDefinition.subName;
            }
            String totalBName = ((AJSONItem)itemB.definition).classification.toDirectory() + ((AJSONItem)itemB.definition).prefixFolders + ((AJSONItem)itemB.definition).systemName;
            if (itemB instanceof AItemSubTyped) {
                totalBName = totalBName + ((AItemSubTyped)itemB).subDefinition.subName;
            }
            if (itemA.getClass().equals(itemB.getClass()) || itemA instanceof AItemPart && itemB instanceof AItemPart) {
                return totalAName.compareTo(totalBName);
            }
            return Integer.compare(this.getItemPriority(itemA), this.getItemPriority(itemB));
        }

        private int getItemPriority(AItemPack<?> item) {
            if (item instanceof ItemVehicle) {
                return 0;
            }
            if (item instanceof AItemPart) {
                return 1;
            }
            if (item instanceof ItemBullet) {
                return 2;
            }
            if (item instanceof ItemDecor) {
                return 3;
            }
            if (item instanceof ItemPoleComponent) {
                return 4;
            }
            if (item instanceof ItemRoadComponent) {
                return 5;
            }
            if (item instanceof ItemItem) {
                return 6;
            }
            if (item instanceof ItemInstrument) {
                return 7;
            }
            if (item instanceof ItemBlock) {
                return 8;
            }
            return Integer.MAX_VALUE;
        }
    };

    public static void parsePacks(List<File> packDirectories) {
        for (File file : packDirectories) {
            for (File file2 : file.listFiles()) {
                if (!file2.getName().endsWith(".jar")) continue;
                PackParser.checkJarForPacks(file2);
            }
        }
        PackParser.parseAllPacks();
        PackParser.parseAllSkins();
        if (ConfigSystem.settings.fuel.fuels == null) {
            ConfigSystem.settings.fuel.fuels = new HashMap<String, Map<String, Double>>();
        }
        for (Map.Entry entry : JSONConfigSettings.ConfigFuel.getDefaultFuels().entrySet()) {
            if (ConfigSystem.settings.fuel.fuels.containsKey(entry.getKey())) continue;
            ConfigSystem.settings.fuel.fuels.put((String)entry.getKey(), (Map)entry.getValue());
        }
        for (String string : packMap.keySet()) {
            if (!((Map)ConfigSystem.settings.general.packSpeedFactors.value).containsKey(string)) {
                ((Map)ConfigSystem.settings.general.packSpeedFactors.value).put(string, 1.0);
            }
            if (!((Map)ConfigSystem.settings.general.packVehicleScales.value).containsKey(string)) {
                ((Map)ConfigSystem.settings.general.packVehicleScales.value).put(string, 1.0);
            }
            if (((Map)ConfigSystem.settings.damage.packBulletDamageFactors.value).containsKey(string)) continue;
            ((Map)ConfigSystem.settings.damage.packBulletDamageFactors.value).put(string, 1.0);
        }
        ConfigSystem.saveToDisk();
        ConfigSystem.initOverrides();
    }

    public static void addDefaultItems() {
        String packID;
        JSONPack packDef = new JSONPack();
        packDef.packID = packID = InterfaceManager.coreModID;
        packDef.fileStructure = 0;
        packDef.packName = InterfaceManager.coreInterface.getModName(packID);
        packDef.packItem = "wrench";
        packMap.put(packID, packDef);
        HashMap<String, PackResourceLoader.ItemClassification> defaultItems = new HashMap<String, PackResourceLoader.ItemClassification>();
        defaultItems.put("fuelhose", PackResourceLoader.ItemClassification.ITEM);
        defaultItems.put("handbook_car", PackResourceLoader.ItemClassification.ITEM);
        defaultItems.put("handbook_plane", PackResourceLoader.ItemClassification.ITEM);
        defaultItems.put("jumpercable", PackResourceLoader.ItemClassification.ITEM);
        defaultItems.put("jumperpack", PackResourceLoader.ItemClassification.ITEM);
        defaultItems.put("key", PackResourceLoader.ItemClassification.ITEM);
        defaultItems.put("paintgun", PackResourceLoader.ItemClassification.ITEM);
        defaultItems.put("partscanner", PackResourceLoader.ItemClassification.ITEM);
        defaultItems.put("ticket", PackResourceLoader.ItemClassification.ITEM);
        defaultItems.put("wrench", PackResourceLoader.ItemClassification.ITEM);
        defaultItems.put("y2kbutton", PackResourceLoader.ItemClassification.ITEM);
        defaultItems.put("jerrycan", PackResourceLoader.ItemClassification.PART);
        defaultItems.put("fuelpump", PackResourceLoader.ItemClassification.DECOR);
        defaultItems.put("charger", PackResourceLoader.ItemClassification.DECOR);
        defaultItems.put("vehiclebench", PackResourceLoader.ItemClassification.DECOR);
        defaultItems.put("enginebench", PackResourceLoader.ItemClassification.DECOR);
        defaultItems.put("propellerbench", PackResourceLoader.ItemClassification.DECOR);
        defaultItems.put("wheelbench", PackResourceLoader.ItemClassification.DECOR);
        defaultItems.put("seatbench", PackResourceLoader.ItemClassification.DECOR);
        defaultItems.put("gunbench", PackResourceLoader.ItemClassification.DECOR);
        defaultItems.put("custombench", PackResourceLoader.ItemClassification.DECOR);
        defaultItems.put("instrumentbench", PackResourceLoader.ItemClassification.DECOR);
        defaultItems.put("decorbench", PackResourceLoader.ItemClassification.DECOR);
        defaultItems.put("itembench", PackResourceLoader.ItemClassification.DECOR);
        defaultItems.put("invisible_seat", PackResourceLoader.ItemClassification.PART);
        defaultItems.put("invisible_standing", PackResourceLoader.ItemClassification.PART);
        defaultItems.put("invisible_wheel", PackResourceLoader.ItemClassification.PART);
        defaultItems.put("default_car", PackResourceLoader.ItemClassification.PANEL);
        defaultItems.put("default_plane", PackResourceLoader.ItemClassification.PANEL);
        String prefixFolders = "/assets/" + packID + "/jsondefs/";
        for (Map.Entry defaultItem : defaultItems.entrySet()) {
            try {
                String systemName = (String)defaultItem.getKey();
                PackResourceLoader.ItemClassification classification = (PackResourceLoader.ItemClassification)((Object)defaultItem.getValue());
                AJSONBase itemDef = JSONParser.parseStream(InterfaceManager.coreInterface.getPackResource(prefixFolders + classification.toDirectory() + systemName + ".json"), classification.representingClass, packDef.packID, systemName);
                itemDef.packID = packID;
                itemDef.systemName = systemName;
                itemDef.classification = classification;
                itemDef.prefixFolders = prefixFolders;
                PackParser.registerItem(itemDef);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void addItemPartCreator(AItemPart.AItemPartCreator creator) {
        partCreators.add(0, creator);
    }

    private static void checkJarForPacks(File packJar) {
        try {
            JSONPack packDef;
            ZipEntry entry;
            boolean foundJSON = false;
            ZipFile jarFile = new ZipFile(packJar);
            Enumeration<? extends ZipEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (!entry.getName().endsWith("/packdefinition.json")) continue;
                packDef = JSONParser.parseStream(jarFile.getInputStream(entry), JSONPack.class, null, null);
                packJarMap.put(packDef.packID, packJar);
                packMap.put(packDef.packID, packDef);
                foundJSON = true;
            }
            if (!foundJSON) {
                entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    if (!entry.getName().endsWith("MTSPackLoader.class")) continue;
                    packDef = new JSONPack();
                    String[] pathComponents = entry.getName().split("/");
                    packDef.packID = pathComponents[pathComponents.length - 2];
                    packDef.packName = "Auto-Generated: " + packDef.packID;
                    packJarMap.put(packDef.packID, packJar);
                    packMap.put(packDef.packID, packDef);
                    break;
                }
            }
            jarFile.close();
        }
        catch (Exception e) {
            InterfaceManager.coreInterface.logError("A fault was encountered when trying to check file " + packJar.getName() + " for pack data.  This pack will not be loaded.");
            e.printStackTrace();
        }
    }

    private static void parseAllPacks() {
        ArrayList<String> packIDs = new ArrayList<String>(packMap.keySet());
        for (String s : packMap.keySet()) {
            JSONPack packDef = packMap.get(s);
            if (packDef.packID.equals(InterfaceManager.coreModID)) continue;
            ArrayList<String> validSubDirectories = new ArrayList<String>();
            if (packDef.activators != null) {
                block7: for (String subDirectory : packDef.activators.keySet()) {
                    if (!packDef.activators.get(subDirectory).isEmpty()) {
                        for (String activator : packDef.activators.get(subDirectory)) {
                            if (!packIDs.contains(activator) && !InterfaceManager.coreInterface.isModPresent(activator)) continue;
                            validSubDirectories.add(subDirectory);
                            continue block7;
                        }
                        continue;
                    }
                    validSubDirectories.add(subDirectory);
                }
            } else {
                validSubDirectories.add("");
            }
            if (packDef.blockers != null) {
                block9: for (String subDirectory : packDef.blockers.keySet()) {
                    for (String blocker : packDef.blockers.get(subDirectory)) {
                        if (!packIDs.contains(blocker) && !InterfaceManager.coreInterface.isModPresent(blocker)) continue;
                        validSubDirectories.remove(subDirectory);
                        continue block9;
                    }
                }
            }
            if (packDef.dependents != null) {
                for (String dependent : packDef.dependents) {
                    if (!packIDs.contains(dependent) && !InterfaceManager.coreInterface.isModPresent(dependent)) continue;
                    faultMap.put(packDef.packID, packDef.dependents);
                    break;
                }
            }
            PackResourceLoader.PackStructure structure = PackResourceLoader.PackStructure.values()[packDef.fileStructure];
            for (String subDirectory : validSubDirectories) {
                String assetPathPrefix = "assets/" + packDef.packID + "/";
                if (!subDirectory.isEmpty()) {
                    assetPathPrefix = assetPathPrefix + subDirectory + "/";
                }
                try {
                    ZipFile jarFile = new ZipFile(packJarMap.get(packDef.packID));
                    Enumeration<? extends ZipEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        AJSONBase definition;
                        PackResourceLoader.ItemClassification classification;
                        ZipEntry entry = entries.nextElement();
                        String entryFullPath = entry.getName();
                        if (!entryFullPath.startsWith(assetPathPrefix) || !entryFullPath.endsWith(".json")) continue;
                        String fileName = entryFullPath.substring(entryFullPath.lastIndexOf(47) + 1);
                        String assetPath = entryFullPath.substring(assetPathPrefix.length(), entryFullPath.substring(0, entryFullPath.length() - fileName.length()).lastIndexOf("/") + 1);
                        if (!structure.equals((Object)PackResourceLoader.PackStructure.MODULAR)) {
                            if (!assetPath.startsWith("jsondefs/")) continue;
                            assetPath = assetPath.substring("jsondefs/".length());
                        }
                        if (fileName.equals("packdefinition.json") || !(structure.equals((Object)PackResourceLoader.PackStructure.MODULAR) ? !fileName.endsWith("_item.json") : entryFullPath.contains("jsondefs"))) continue;
                        try {
                            classification = PackResourceLoader.ItemClassification.fromDirectory(assetPath.substring(0, assetPath.indexOf("/") + 1));
                        }
                        catch (Exception e) {
                            InterfaceManager.coreInterface.logError("Was given an invalid classifcation sub-folder for asset: " + fileName + ".  Check your folder paths.");
                            continue;
                        }
                        String systemName = fileName.substring(0, fileName.length() - ".json".length());
                        try {
                            definition = JSONParser.parseStream(jarFile.getInputStream(entry), classification.representingClass, packDef.packID, systemName);
                        }
                        catch (Exception e) {
                            InterfaceManager.coreInterface.logError("Could not parse: " + packDef.packID + ":" + fileName);
                            InterfaceManager.coreInterface.logError(e.getMessage());
                            continue;
                        }
                        definition.packID = packDef.packID;
                        definition.systemName = systemName;
                        definition.classification = classification;
                        definition.prefixFolders = assetPath.substring(classification.toDirectory().length());
                        PackParser.registerItem(definition);
                    }
                    jarFile.close();
                }
                catch (Exception e) {
                    InterfaceManager.coreInterface.logError("Could not start parsing of pack: " + packDef.packID);
                    e.printStackTrace();
                }
            }
        }
    }

    public static void registerItem(AJSONBase itemDef) {
        try {
            LegacyCompatSystem.performLegacyCompats(itemDef);
            JSONParser.validateFields(itemDef, itemDef.packID + ":" + itemDef.systemName + "/", 1);
            if (itemDef instanceof AJSONMultiModelProvider) {
                if (itemDef instanceof JSONSkin) {
                    JSONSkin skinDef = (JSONSkin)itemDef;
                    if (!skinMap.containsKey(skinDef.skin.packID)) {
                        skinMap.put(skinDef.skin.packID, new HashMap());
                    }
                    if (!skinMap.get(skinDef.skin.packID).containsKey(skinDef.skin.systemName)) {
                        skinMap.get(skinDef.skin.packID).put(skinDef.skin.systemName, new ArrayList());
                    }
                    skinMap.get(skinDef.skin.packID).get(skinDef.skin.systemName).add(skinDef);
                } else {
                    PackParser.parseAllDefinitions((AJSONMultiModelProvider)itemDef, ((AJSONMultiModelProvider)itemDef).definitions, itemDef.packID);
                }
            } else {
                AItemPack item = null;
                switch (itemDef.classification) {
                    case INSTRUMENT: {
                        item = new ItemInstrument((JSONInstrument)itemDef);
                        break;
                    }
                    case ITEM: {
                        item = new ItemItem((JSONItem)itemDef);
                        break;
                    }
                    case BLOCK: {
                        item = new ItemBlock((JSONBlock)itemDef);
                        break;
                    }
                    case PANEL: {
                        JSONPanel panelDef = (JSONPanel)itemDef;
                        if (!panelMap.containsKey(panelDef.packID)) {
                            panelMap.put(panelDef.packID, new HashMap());
                        }
                        panelMap.get(panelDef.packID).put(panelDef.systemName, panelDef);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No corresponding classification found for asset: " + itemDef.prefixFolders + " Contact the mod author!");
                    }
                }
                if (item != null) {
                    if (!packItemMap.containsKey(((AJSONItem)item.definition).packID)) {
                        packItemMap.put(((AJSONItem)item.definition).packID, new HashMap());
                    }
                    packItemMap.get(((AJSONItem)item.definition).packID).put(((AJSONItem)item.definition).systemName, item);
                }
            }
        }
        catch (Exception e) {
            InterfaceManager.coreInterface.logError(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void parseAllSkins() {
        for (String packID : skinMap.keySet()) {
            if (!packItemMap.containsKey(packID)) continue;
            block1: for (String systemName : skinMap.get(packID).keySet()) {
                for (AItemPack<?> packItem : packItemMap.get(packID).values()) {
                    if (!((AJSONItem)packItem.definition).systemName.equals(systemName)) continue;
                    AJSONMultiModelProvider oldDefinition = (AJSONMultiModelProvider)packItem.definition;
                    for (JSONSkin skinDef : skinMap.get(packID).get(systemName)) {
                        PackParser.parseAllDefinitions(oldDefinition, skinDef.definitions, skinDef.packID);
                        oldDefinition.definitions.addAll(skinDef.definitions);
                    }
                    continue block1;
                }
            }
        }
    }

    private static void parseAllDefinitions(AJSONMultiModelProvider mainDefinition, List<JSONSubDefinition> subDefinitions, String sourcePackID) {
        HashMap<String, ItemVehicle> packItems = new HashMap<String, ItemVehicle>();
        for (JSONSubDefinition subDefinition : subDefinitions) {
            AItemSubTyped item = null;
            switch (mainDefinition.classification) {
                case VEHICLE: {
                    item = new ItemVehicle((JSONVehicle)mainDefinition, subDefinition, sourcePackID);
                    break;
                }
                case PART: {
                    JSONPart partDef = (JSONPart)mainDefinition;
                    for (AItemPart.AItemPartCreator creator : partCreators) {
                        if (!creator.isCreatorValid(partDef)) continue;
                        item = creator.createItem(partDef, subDefinition, sourcePackID);
                        break;
                    }
                    if (item != null) break;
                    InterfaceManager.coreInterface.logError("Was told to parse part " + partDef.packID + ":" + partDef.systemName + " with part type " + partDef.generic.type + ", but that's not a valid type for creating a part.");
                    return;
                }
                case DECOR: {
                    item = new ItemDecor((JSONDecor)mainDefinition, subDefinition, sourcePackID);
                    break;
                }
                case POLE: {
                    item = new ItemPoleComponent((JSONPoleComponent)mainDefinition, subDefinition, sourcePackID);
                    break;
                }
                case ROAD: {
                    item = new ItemRoadComponent((JSONRoadComponent)mainDefinition, subDefinition, sourcePackID);
                    break;
                }
                case BULLET: {
                    item = new ItemBullet((JSONBullet)mainDefinition, subDefinition, sourcePackID);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("A classification for a normal item is trying to register as a multi-model provider.  This is an error in the core mod.  Contact the mod author.  Asset being loaded is: " + mainDefinition.packID + ":" + mainDefinition.systemName);
                }
            }
            packItems.put(((AJSONItem)item.definition).systemName + subDefinition.subName, (ItemVehicle)item);
        }
        if (!packItemMap.containsKey(mainDefinition.packID)) {
            packItemMap.put(mainDefinition.packID, new HashMap());
        }
        packItemMap.get(mainDefinition.packID).putAll(packItems);
    }

    public static void sortPackItems(String packID) {
        HashMap<String, AItemPack<?>> packSpecificItemMap = packItemMap.get(packID);
        ArrayList packItems = new ArrayList(packSpecificItemMap.values());
        packItems.sort(packComparator);
        packSpecificItemMap.clear();
        for (AItemPack aItemPack : packItems) {
            if (aItemPack.definition instanceof AJSONMultiModelProvider) {
                packSpecificItemMap.put(((AJSONItem)aItemPack.definition).systemName, aItemPack);
                continue;
            }
            packSpecificItemMap.put(((AJSONItem)aItemPack.definition).systemName, aItemPack);
        }
    }

    public static <PackItem extends AItemPack<JSONDefinition>, JSONDefinition extends AJSONItem> PackItem getItem(String packID, String systemName) {
        return PackParser.getItem(packID, systemName, "");
    }

    public static <PackItem extends AItemPack<JSONDefinition>, JSONDefinition extends AJSONItem> PackItem getItem(String packID, String systemName, String subName) {
        if (packItemMap.containsKey(packID)) {
            return (PackItem)packItemMap.get(packID).get(systemName + subName);
        }
        return null;
    }

    public static boolean arePacksPresent() {
        return packItemMap.size() > 1;
    }

    public static Set<String> getAllPackIDs() {
        return packItemMap.keySet();
    }

    public static JSONPack getPackConfiguration(String packID) {
        return packMap.get(packID);
    }

    public static List<AItemPack<?>> getAllItemsForPack(String packID, boolean sorted) {
        ArrayList packItems = new ArrayList(packItemMap.get(packID).values());
        if (sorted) {
            packItems.sort(packComparator);
        }
        return packItems;
    }

    public static List<AItemPack<?>> getAllPackItems() {
        ArrayList packItems = new ArrayList();
        for (String packID : packItemMap.keySet()) {
            packItems.addAll(PackParser.getAllItemsForPack(packID, false));
        }
        return packItems;
    }

    public static JSONPanel getPackPanel(String packID, String systemName) {
        if (panelMap.containsKey(packID)) {
            return panelMap.get(packID).get(systemName);
        }
        return null;
    }

    public static List<JSONPanel> getAllPanelsForPack(String packID) {
        return panelMap.containsKey(packID) ? new ArrayList<JSONPanel>(panelMap.get(packID).values()) : new ArrayList();
    }

    public static List<JSONPanel> getAllPackPanels() {
        ArrayList<JSONPanel> packPanels = new ArrayList<JSONPanel>();
        for (Map<String, JSONPanel> panels : panelMap.values()) {
            packPanels.addAll(panels.values());
        }
        return packPanels;
    }
}

